<?php

class api_events_model extends CI_Model {

	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $events = 'events e';
	var $events_config = 'events_config ec';
	var $event_types = 'event_types et';
	var $seatplans = 'seatplans sp';
	var $prices = 'prices pr';

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
    
	function get($event_id)
	{
		$this->db->where('event_id', $event_id);
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->join($this->seatplans, 'e.event_seatplan_id = sp.seatplan_id', 'left');
		$query = $this->db->get($this->events);
		//echo $this->db->last_query();
		if($query->num_rows() > 0){
			return $query->row();
		}else{
			return false;
		}
		
	}
	
	function get_event_id($price_id, $section_id)
	{
		$retval = 0;
		$this->db->where('price_id', $price_id);
		$query = $this->db->get($this->prices);
		$prices = $query->result();
		foreach ($prices as $price)
		{
			$sections = unserialize($price->price_sections);
			if (in_array($section_id, $sections))
			{
			$retval = $price->price_event_id;
			}
		}
		return $retval;
	}

	function get_event_type($event_id = false){

		$this->db->select('event_type');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get($this->events);
		if(!$query->row()){
		return false;
		}
		else{
		return $query->row()->event_type;
		}
		
	}

	
}


